/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.grenade.EntityGrenadeTau;
import com.hbm.entity.grenade.EntityGrenadeZOMG;
import com.hbm.entity.missile.EntityMIRV;
import com.hbm.entity.missile.EntityMissileAntiBallistic;
import com.hbm.entity.missile.EntityMissileBase;
import com.hbm.entity.particle.EntityChlorineFX;
import com.hbm.entity.particle.EntityCloudFX;
import com.hbm.entity.particle.EntityModFX;
import com.hbm.entity.particle.EntityOrangeFX;
import com.hbm.entity.particle.EntityPinkCloudFX;
import com.hbm.entity.projectile.EntityBullet;
import com.hbm.entity.projectile.EntityRainbow;
import com.hbm.entity.projectile.EntityRocket;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.entity.projectile.EntitySchrab;
import com.hbm.lib.ModDamageSource;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ExplosionChaos {
    private static final Random random = new Random();
    private static Random rand = new Random();

    public static void explode(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    ExplosionChaos.destruction(world, X, Y, Z);
                }
            }
        }
    }

    public static void antiCheat(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || rand.nextInt(15) != 0 || world.func_147439_a(X, Y, Z) == Blocks.field_150350_a) continue;
                    world.func_147449_b(X, Y, Z, ModBlocks.cheater_virus);
                }
            }
        }
    }

    public static void hardenVirus(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || world.func_147439_a(X, Y, Z) != ModBlocks.crystal_virus) continue;
                    world.func_147449_b(X, Y, Z, ModBlocks.crystal_hardened);
                }
            }
        }
    }

    public static void spreadVirus(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || rand.nextInt(15) != 0 || world.func_147439_a(X, Y, Z) == Blocks.field_150350_a) continue;
                    world.func_147449_b(X, Y, Z, ModBlocks.cheater_virus_seed);
                }
            }
        }
    }

    public static void pulse(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || !(world.func_147439_a(X, Y, Z).func_149638_a(null) <= 70.0f)) continue;
                    ExplosionChaos.pDestruction(world, X, Y, Z);
                }
            }
        }
    }

    public static void explodeZOMG(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || world.func_147439_a(X, Y, Z) == Blocks.field_150357_h && Y <= 0) continue;
                    world.func_147449_b(X, Y, Z, Blocks.field_150350_a);
                }
            }
        }
    }

    public static void decon(World world, int x, int y, int z, int radius) {
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    ExplosionChaos.decontaminate(world, X, Y, Z);
                }
            }
        }
    }

    public static void spawnExplosion(World world, int x, int y, int z, int bound) {
        for (int i = 0; i < 25; ++i) {
            int randX = random.nextInt(bound);
            int randY = random.nextInt(bound);
            int randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
        }
    }

    public static void flameDeath(World world, int x, int y, int z, int bound) {
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || !world.func_147439_a(X, Y, Z).isFlammable((IBlockAccess)world, XX, YY, ZZ, ForgeDirection.UP) || world.func_147439_a(X, Y + 1, Z) != Blocks.field_150350_a) continue;
                    world.func_147449_b(X, Y + 1, Z, (Block)Blocks.field_150480_ab);
                }
            }
        }
    }

    public static void burn(World world, int x, int y, int z, int bound) {
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || world.func_147439_a(X, Y + 1, Z) != Blocks.field_150350_a && world.func_147439_a(X, Y + 1, Z) != Blocks.field_150431_aC || world.func_147439_a(X, Y, Z) == Blocks.field_150350_a) continue;
                    world.func_147449_b(X, Y + 1, Z, (Block)Blocks.field_150480_ab);
                }
            }
        }
    }

    public static void spawnChlorine(World world, double x, double y, double z, int count, double speed, int type) {
        for (int i = 0; i < count; ++i) {
            EntityModFX fx = null;
            fx = type == 0 ? new EntityChlorineFX(world, x, y, z, 0.0, 0.0, 0.0) : (type == 1 ? new EntityCloudFX(world, x, y, z, 0.0, 0.0, 0.0) : (type == 2 ? new EntityPinkCloudFX(world, x, y, z, 0.0, 0.0, 0.0) : new EntityOrangeFX(world, x, y, z, 0.0, 0.0, 0.0)));
            fx.field_70181_x = rand.nextGaussian() * speed;
            fx.field_70159_w = rand.nextGaussian() * speed;
            fx.field_70179_y = rand.nextGaussian() * speed;
            world.func_72838_d((Entity)fx);
        }
    }

    public static void spawnVolley(World world, double x, double y, double z, int count, double speed) {
        for (int i = 0; i < count; ++i) {
            EntityOrangeFX fx = new EntityOrangeFX(world, x, y, z, 0.0, 0.0, 0.0);
            fx.field_70159_w = rand.nextGaussian() * speed;
            fx.field_70179_y = rand.nextGaussian() * speed;
            fx.field_70181_x = rand.nextDouble() * speed * 7.5;
            world.func_72838_d((Entity)fx);
        }
    }

    public static void destruction(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && world.func_147439_a(x, y, z) != ModBlocks.reinforced_brick && world.func_147439_a(x, y, z) != ModBlocks.reinforced_sand && world.func_147439_a(x, y, z) != ModBlocks.reinforced_glass && world.func_147439_a(x, y, z) != ModBlocks.reinforced_lamp_on && world.func_147439_a(x, y, z) != ModBlocks.reinforced_lamp_off) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public static void pDestruction(World world, int x, int y, int z) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
        world.func_72838_d((Entity)entityfallingblock);
    }

    public static void cluster(World world, int x, int y, int z, int count, int gravity) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityRocket fragment = new EntityRocket(world, x, y, z, d1, d2, d3, 0.0125);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void schrab(World world, int x, int y, int z, int count, int gravity) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntitySchrab fragment = new EntitySchrab(world, x, y, z, d1, d2, d3, 0.0125);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void nuke(World world, int x, int y, int z, int count) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 5; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityTNTPrimed fragment = new EntityTNTPrimed(world);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void frag(World world, int x, int y, int z, int count, boolean flame, Entity shooter) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityArrow fragment = new EntityArrow(world, (double)x, (double)y, (double)z);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            fragment.field_70250_c = shooter;
            fragment.func_70243_d(true);
            if (flame) {
                fragment.func_70015_d(1000);
            }
            fragment.func_70239_b(2.5);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void anvil(World world, int x, int y, int z, int count) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            world.func_147449_b(x, y, z, Blocks.field_150467_bQ);
            EntityFallingBlock fragment = new EntityFallingBlock(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, Blocks.field_150467_bQ);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void poison(World world, int x, int y, int z, int bombStartStrength) {
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat)) continue;
            if (entity instanceof EntityPlayer && ArmorUtil.checkForGasMask((EntityPlayer)entity)) {
                ArmorUtil.damageSuit((EntityPlayer)entity, 3, rand.nextInt(2));
                continue;
            }
            if (!(entity instanceof EntityLivingBase)) continue;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 100, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 400, 2));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 20, 1));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 600, 1));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 600, 2));
        }
        bombStartStrength = (int)f;
    }

    public static void pc(World world, int x, int y, int z, int bombStartStrength) {
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat)) continue;
            if (entity instanceof EntityPlayer) {
                ArmorUtil.damageSuit((EntityPlayer)entity, 0, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 1, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 2, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 3, 25);
            }
            entity.func_70097_a(ModDamageSource.pc, 5.0f);
        }
        bombStartStrength = (int)f;
    }

    public static void c(World world, int x, int y, int z, int bombStartStrength) {
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat)) continue;
            if (entity instanceof EntityPlayer) {
                ArmorUtil.damageSuit((EntityPlayer)entity, 0, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 1, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 2, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 3, 5);
            }
            if (entity instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityPlayer)entity)) continue;
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_82165_m(HbmPotion.taint.field_76415_H)) {
                ((EntityLivingBase)entity).func_82170_o(HbmPotion.taint.field_76415_H);
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(HbmPotion.mutation.field_76415_H, 72000, 0, false));
                continue;
            }
            entity.func_70097_a(ModDamageSource.cloud, 3.0f);
        }
        bombStartStrength = (int)f;
    }

    public static void floater(World world, int x, int y, int z, int radi, int height) {
        int r = radi;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    Block save = world.func_147439_a(X, Y, Z);
                    int meta = world.func_72805_g(X, Y, Z);
                    world.func_147449_b(X, Y, Z, Blocks.field_150350_a);
                    if (save == Blocks.field_150350_a) continue;
                    world.func_147449_b(X, Y + height, Z, save);
                    world.func_72921_c(X, Y + height, Z, meta, 2);
                }
            }
        }
    }

    public static void move(World world, int x, int y, int z, int radius, int a, int b, int c) {
        float f = radius;
        double wat = radius;
        int rand = 0;
        radius = (int)((float)radius * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0)) continue;
            double d5 = entity.field_70165_t - (double)x;
            double d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y;
            double d7 = entity.field_70161_v - (double)z;
            if (entity instanceof EntityLiving && !(entity instanceof EntitySheep)) {
                rand = random.nextInt(2);
                if (rand == 0) {
                    ((EntityLiving)entity).func_94058_c("Dinnerbone");
                } else {
                    ((EntityLiving)entity).func_94058_c("Grumm");
                }
            }
            if (entity instanceof EntitySheep) {
                ((EntityLiving)entity).func_94058_c("jeb_");
            }
            if (!((d9 = (double)MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7))) < wat)) continue;
            entity.func_70107_b(entity.field_70165_t += (double)a, entity.field_70163_u += (double)b, entity.field_70161_v += (double)c);
        }
        radius = (int)f;
    }

    public static Entity getHomingTarget(World world, int x, int y, int z, int radius, Entity e) {
        float f = radius;
        double wat = radius * 2;
        radius = (int)((float)radius * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(e, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0)) continue;
            double d5 = entity.field_70165_t - (double)x;
            double d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y;
            double d7 = entity.field_70161_v - (double)z;
            double d9 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            if (!(entity instanceof EntityMissileBase) || entity instanceof EntityMissileAntiBallistic) continue;
            return entity;
        }
        radius = (int)f;
        return null;
    }

    public static void delMissiles(World world, int x, int y, int z, int radius, Entity e) {
        float f = radius;
        double wat = radius * 2;
        radius = (int)((float)radius * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(e, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0)) continue;
            double d5 = entity.field_70165_t - (double)x;
            double d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y;
            double d7 = entity.field_70161_v - (double)z;
            double d9 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            if (!(entity instanceof EntityMissileBase)) continue;
            entity = null;
        }
        radius = (int)f;
    }

    public static void mirv(World world, double x, double y, double z) {
        double modifier = 2.5;
        double zeta = Math.sqrt(2.0) / 2.0;
        EntityMIRV mirv1 = new EntityMIRV(world);
        EntityMIRV mirv2 = new EntityMIRV(world);
        EntityMIRV mirv3 = new EntityMIRV(world);
        EntityMIRV mirv4 = new EntityMIRV(world);
        double vx1 = 1.0;
        double vy1 = rand.nextDouble() * -1.0;
        double vz1 = 0.0;
        mirv1.field_70165_t = x;
        mirv1.field_70163_u = y;
        mirv1.field_70161_v = z;
        mirv1.field_70181_x = vy1;
        mirv2.field_70165_t = x;
        mirv2.field_70163_u = y;
        mirv2.field_70161_v = z;
        mirv2.field_70181_x = vy1;
        mirv3.field_70165_t = x;
        mirv3.field_70163_u = y;
        mirv3.field_70161_v = z;
        mirv3.field_70181_x = vy1;
        mirv4.field_70165_t = x;
        mirv4.field_70163_u = y;
        mirv4.field_70161_v = z;
        mirv4.field_70181_x = vy1;
        mirv1.field_70159_w = vx1 * modifier;
        mirv1.field_70179_y = vz1 * modifier;
        world.func_72838_d((Entity)mirv1);
        mirv2.field_70159_w = -vz1 * modifier;
        mirv2.field_70179_y = vx1 * modifier;
        world.func_72838_d((Entity)mirv2);
        mirv3.field_70159_w = -vx1 * modifier;
        mirv3.field_70179_y = -vz1 * modifier;
        world.func_72838_d((Entity)mirv3);
        mirv4.field_70159_w = vz1 * modifier;
        mirv4.field_70179_y = -vx1 * modifier;
        world.func_72838_d((Entity)mirv4);
        EntityMIRV mirv5 = new EntityMIRV(world);
        EntityMIRV mirv6 = new EntityMIRV(world);
        EntityMIRV mirv7 = new EntityMIRV(world);
        EntityMIRV mirv8 = new EntityMIRV(world);
        double vx2 = zeta;
        double vy2 = vy1;
        double vz2 = zeta;
        mirv5.field_70165_t = x;
        mirv5.field_70163_u = y;
        mirv5.field_70161_v = z;
        mirv5.field_70181_x = vy2;
        mirv6.field_70165_t = x;
        mirv6.field_70163_u = y;
        mirv6.field_70161_v = z;
        mirv6.field_70181_x = vy2;
        mirv7.field_70165_t = x;
        mirv7.field_70163_u = y;
        mirv7.field_70161_v = z;
        mirv7.field_70181_x = vy2;
        mirv8.field_70165_t = x;
        mirv8.field_70163_u = y;
        mirv8.field_70161_v = z;
        mirv8.field_70181_x = vy2;
        mirv5.field_70159_w = vx2 * modifier;
        mirv5.field_70179_y = vz2 * modifier;
        world.func_72838_d((Entity)mirv5);
        mirv6.field_70159_w = -vz2 * modifier;
        mirv6.field_70179_y = vx2 * modifier;
        world.func_72838_d((Entity)mirv6);
        mirv7.field_70159_w = -vx2 * modifier;
        mirv7.field_70179_y = -vz2 * modifier;
        world.func_72838_d((Entity)mirv7);
        mirv8.field_70159_w = vz2 * modifier;
        mirv8.field_70179_y = -vx2 * modifier;
        world.func_72838_d((Entity)mirv8);
    }

    public static void plasma(World world, int x, int y, int z, int radius) {
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 2) || world.func_147439_a(X, Y, Z) == Blocks.field_150357_h || world.func_147439_a(X, Y, Z) == ModBlocks.statue_elb || world.func_147439_a(X, Y, Z) == ModBlocks.statue_elb_g || world.func_147439_a(X, Y, Z) == ModBlocks.statue_elb_w || world.func_147439_a(X, Y, Z) == ModBlocks.statue_elb_f) continue;
                    world.func_147449_b(X, Y, Z, ModBlocks.plasma);
                }
            }
        }
    }

    public static void tauMeSinPi(World world, double x, double y, double z, int count, Entity shooter, EntityGrenadeTau tau) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (shooter != null && shooter instanceof EntityPlayer) {
            for (int i = 0; i < count; ++i) {
                EntityBullet fragment;
                d1 = rand.nextDouble();
                d2 = rand.nextDouble();
                d3 = rand.nextDouble();
                if (rand.nextInt(2) == 0) {
                    d1 *= -1.0;
                }
                if (rand.nextInt(2) == 0) {
                    d2 *= -1.0;
                }
                if (rand.nextInt(2) == 0) {
                    d3 *= -1.0;
                }
                if (rand.nextInt(5) == 0) {
                    fragment = new EntityBullet(world, (EntityLivingBase)((EntityPlayer)shooter), 3.0f, 35, 45, false, "tauDay", tau);
                    fragment.setDamage(rand.nextInt(301) + 100);
                } else {
                    fragment = new EntityBullet(world, (EntityLivingBase)((EntityPlayer)shooter), 3.0f, 35, 45, false, "eyyOk", tau);
                    fragment.setDamage(rand.nextInt(11) + 35);
                }
                fragment.field_70159_w = d1 * 5.0;
                fragment.field_70181_x = d2 * 5.0;
                fragment.field_70179_y = d3 * 5.0;
                fragment.shootingEntity = shooter;
                fragment.setIsCritical(true);
                world.func_72838_d((Entity)fragment);
            }
        }
    }

    public static void zomgMeSinPi(World world, double x, double y, double z, int count, Entity shooter, EntityGrenadeZOMG zomg) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d2 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityRainbow entityZomg = new EntityRainbow(world, (EntityLivingBase)((EntityPlayer)shooter), 1.0f, 10000, 100000, zomg);
            entityZomg.field_70159_w = d1;
            entityZomg.field_70181_x = d2;
            entityZomg.field_70179_y = d3;
            entityZomg.shootingEntity = shooter;
            world.func_72838_d((Entity)entityZomg);
            world.func_72956_a((Entity)zomg, "hbm:weapon.zomgShoot", 10.0f, 0.8f + rand.nextFloat() * 0.4f);
        }
    }

    public static void levelDown(World world, int x, int y, int z, int radius) {
        if (!world.field_72995_K) {
            for (int i = x - radius; i <= x + radius; ++i) {
                for (int j = z - radius; j <= z + radius; ++j) {
                    Block b = world.func_147439_a(i, y, j);
                    float k = b.func_149638_a(null);
                    if (!(k < 6000.0f) || b == Blocks.field_150350_a) continue;
                    EntityRubble rubble = new EntityRubble(world);
                    rubble.field_70165_t = (float)i + 0.5f;
                    rubble.field_70163_u = y;
                    rubble.field_70161_v = (float)j + 0.5f;
                    rubble.field_70181_x = 0.4f;
                    rubble.setMetaBasedOnBlock(b, world.func_72805_g(i, y, j));
                    world.func_72838_d((Entity)rubble);
                    world.func_147449_b(i, y, j, Blocks.field_150350_a);
                }
            }
        }
    }

    public static void decontaminate(World world, int x, int y, int z) {
        Random random = new Random();
        if (world.func_147439_a(x, y, z) == ModBlocks.waste_earth && random.nextInt(3) != 0) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.waste_mycelium && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150391_bh);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.waste_trinitite && random.nextInt(3) == 0) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.waste_trinitite_red && random.nextInt(3) == 0) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150354_m, 1, 2);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.waste_log && random.nextInt(3) != 0) {
            world.func_147449_b(x, y, z, Blocks.field_150364_r);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.waste_planks && random.nextInt(3) != 0) {
            world.func_147449_b(x, y, z, Blocks.field_150344_f);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.block_trinitite && random.nextInt(10) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.block_lead);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.block_waste && random.nextInt(10) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.block_lead);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_core && random.nextInt(10) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_4);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_4 && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_3);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_3 && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_2);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_2 && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_1);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_1 && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_0);
        } else if (world.func_147439_a(x, y, z) == ModBlocks.sellafield_0 && random.nextInt(5) == 0) {
            world.func_147449_b(x, y, z, ModBlocks.sellafield_slaked);
        }
    }
}

