/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import api.hbm.entity.IRadiationImmune;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.mob.ai.EntityAITaintedCreeperSwell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityTaintedCreeper
extends EntityMob
implements IRadiationImmune {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 20;

    public EntityTaintedCreeper(World p_i1733_1_) {
        super(p_i1733_1_);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITaintedCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityOcelot.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected void func_70069_a(float p_70069_1_) {
        super.func_70069_a(p_70069_1_);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + p_70069_1_ * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            p_70014_1_.func_74757_a("powered", true);
        }
        p_70014_1_.func_74777_a("Fuse", (short)this.fuseTime);
        p_70014_1_.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        p_70014_1_.func_74757_a("ignited", this.func_146078_ca());
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(p_70037_1_.func_74767_n("powered") ? 1 : 0)));
        if (p_70037_1_.func_150297_b("Fuse", 99)) {
            this.fuseTime = p_70037_1_.func_74765_d("Fuse");
        }
        if (p_70037_1_.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = p_70037_1_.func_74771_c("ExplosionRadius");
        }
        if (p_70037_1_.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 0.4f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.func_146077_cc();
            }
        }
        super.func_70071_h_();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 10 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150335_W);
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int p_70829_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70829_1_));
    }

    public void func_70077_a(EntityLightningBolt p_70077_1_) {
        super.func_70077_a(p_70077_1_);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    protected boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack itemstack = p_70085_1_.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            p_70085_1_.func_71038_i();
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_77972_a(1, (EntityLivingBase)p_70085_1_);
                return true;
            }
        }
        return super.func_70085_c(p_70085_1_);
    }

    private void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (this.getPowered()) {
                this.explosionRadius *= 3;
            }
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, false, false);
            if (this.getPowered()) {
                for (int i = 0; i < 255; ++i) {
                    int c;
                    int b;
                    int a = this.field_70146_Z.nextInt(15) + (int)this.field_70165_t - 7;
                    if (!this.field_70170_p.func_147439_a(a, b = this.field_70146_Z.nextInt(15) + (int)this.field_70163_u - 7, c = this.field_70146_Z.nextInt(15) + (int)this.field_70161_v - 7).isReplaceable((IBlockAccess)this.field_70170_p, a, b, c) || !EntityTaintedCreeper.hasPosNeightbour(this.field_70170_p, a, b, c)) continue;
                    if (!GeneralConfig.enableHardcoreTaint) {
                        this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(3) + 5, 2);
                        continue;
                    }
                    this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(3), 2);
                }
            } else {
                for (int i = 0; i < 85; ++i) {
                    int c;
                    int b;
                    int a = this.field_70146_Z.nextInt(7) + (int)this.field_70165_t - 3;
                    if (!this.field_70170_p.func_147439_a(a, b = this.field_70146_Z.nextInt(7) + (int)this.field_70163_u - 3, c = this.field_70146_Z.nextInt(7) + (int)this.field_70161_v - 3).isReplaceable((IBlockAccess)this.field_70170_p, a, b, c) || !EntityTaintedCreeper.hasPosNeightbour(this.field_70170_p, a, b, c)) continue;
                    if (!GeneralConfig.enableHardcoreTaint) {
                        this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(6) + 10, 2);
                        continue;
                    }
                    this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(3) + 4, 2);
                }
            }
            this.func_70106_y();
        }
    }

    public static boolean hasPosNeightbour(World world, int x, int y, int z) {
        Block b0 = world.func_147439_a(x + 1, y, z);
        Block b1 = world.func_147439_a(x, y + 1, z);
        Block b2 = world.func_147439_a(x, y, z + 1);
        Block b3 = world.func_147439_a(x - 1, y, z);
        Block b4 = world.func_147439_a(x, y - 1, z);
        Block b5 = world.func_147439_a(x, y, z - 1);
        boolean b = b0.func_149686_d() && b0.func_149688_o().func_76218_k() || b1.func_149686_d() && b1.func_149688_o().func_76218_k() || b2.func_149686_d() && b2.func_149688_o().func_76218_k() || b3.func_149686_d() && b3.func_149688_o().func_76218_k() || b4.func_149686_d() && b4.func_149688_o().func_76218_k() || b5.func_149686_d() && b5.func_149688_o().func_76218_k();
        return b;
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public void setPowered(int power) {
        this.field_70180_af.func_75692_b(17, (Object)power);
    }
}

