/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.BlockTaint;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.MissileStruct;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityMissileCustom
extends Entity
implements IChunkLoader,
IRadarDetectable {
    int startX;
    int startZ;
    int targetX;
    int targetZ;
    double velocity;
    double decelY;
    double accelXZ;
    float fuel;
    float consumption;
    private ForgeChunkManager.Ticket loaderTicket;
    public int health = 50;
    MissileStruct template;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissileCustom(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health = (int)((float)this.health - p_70097_2_);
            if (this.health <= 0) {
                this.func_70106_y();
                this.killMissile();
            }
        }
        return true;
    }

    private void killMissile() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
    }

    public EntityMissileCustom(World world, float x, float y, float z, int a, int b, MissileStruct template) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        this.template = template;
        this.field_70180_af.func_75692_b(9, (Object)Item.func_150891_b((Item)template.warhead));
        this.field_70180_af.func_75692_b(10, (Object)Item.func_150891_b((Item)template.fuselage));
        if (template.fins != null) {
            this.field_70180_af.func_75692_b(11, (Object)Item.func_150891_b((Item)template.fins));
        } else {
            this.field_70180_af.func_75692_b(11, (Object)0);
        }
        this.field_70180_af.func_75692_b(12, (Object)Item.func_150891_b((Item)template.thruster));
        Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        ItemMissile fuselage = template.fuselage;
        ItemMissile thruster = template.thruster;
        this.fuel = ((Float)fuselage.attributes[1]).floatValue();
        this.consumption = ((Float)thruster.attributes[1]).floatValue();
        this.func_70105_a(1.5f, 1.5f);
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(8, (Object)this.health);
        if (this.template != null) {
            this.field_70180_af.func_75682_a(9, (Object)Item.func_150891_b((Item)this.template.warhead));
            this.field_70180_af.func_75682_a(10, (Object)Item.func_150891_b((Item)this.template.fuselage));
            if (this.template.fins != null) {
                this.field_70180_af.func_75682_a(11, (Object)Item.func_150891_b((Item)this.template.fins));
            } else {
                this.field_70180_af.func_75682_a(11, (Object)0);
            }
            this.field_70180_af.func_75682_a(12, (Object)Item.func_150891_b((Item)this.template.thruster));
        } else {
            this.field_70180_af.func_75682_a(9, (Object)0);
            this.field_70180_af.func_75682_a(10, (Object)0);
            this.field_70180_af.func_75682_a(11, (Object)0);
            this.field_70180_af.func_75682_a(12, (Object)0);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70159_w = nbt.func_74769_h("moX");
        this.field_70181_x = nbt.func_74769_h("moY");
        this.field_70179_y = nbt.func_74769_h("moZ");
        this.field_70165_t = nbt.func_74769_h("poX");
        this.field_70163_u = nbt.func_74769_h("poY");
        this.field_70161_v = nbt.func_74769_h("poZ");
        this.decelY = nbt.func_74769_h("decel");
        this.accelXZ = nbt.func_74769_h("accel");
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startZ = nbt.func_74762_e("sZ");
        this.velocity = nbt.func_74762_e("veloc");
        this.fuel = nbt.func_74760_g("fuel");
        this.consumption = nbt.func_74760_g("consumption");
        this.field_70180_af.func_75692_b(9, (Object)nbt.func_74762_e("warhead"));
        this.field_70180_af.func_75692_b(10, (Object)nbt.func_74762_e("fuselage"));
        this.field_70180_af.func_75692_b(11, (Object)nbt.func_74762_e("fins"));
        this.field_70180_af.func_75692_b(12, (Object)nbt.func_74762_e("thruster"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("moX", this.field_70159_w);
        nbt.func_74780_a("moY", this.field_70181_x);
        nbt.func_74780_a("moZ", this.field_70179_y);
        nbt.func_74780_a("poX", this.field_70165_t);
        nbt.func_74780_a("poY", this.field_70163_u);
        nbt.func_74780_a("poZ", this.field_70161_v);
        nbt.func_74780_a("decel", this.decelY);
        nbt.func_74780_a("accel", this.accelXZ);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74780_a("veloc", this.velocity);
        nbt.func_74776_a("fuel", this.fuel);
        nbt.func_74776_a("consumption", this.consumption);
        nbt.func_74768_a("warhead", this.field_70180_af.func_75679_c(9));
        nbt.func_74768_a("fuselage", this.field_70180_af.func_75679_c(10));
        nbt.func_74768_a("fins", this.field_70180_af.func_75679_c(11));
        nbt.func_74768_a("thruster", this.field_70180_af.func_75679_c(12));
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void func_70071_h_() {
        this.field_70180_af.func_75692_b(8, (Object)this.health);
        this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, 0.0f, 0.0f);
        this.rotation();
        if (this.fuel > 0.0f || this.field_70170_p.field_72995_K) {
            this.fuel -= this.consumption;
            this.field_70181_x -= this.decelY * this.velocity;
            Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
            vector = vector.func_72432_b();
            vector.field_72450_a *= this.accelXZ * this.velocity;
            vector.field_72449_c *= this.accelXZ * this.velocity;
            if (this.field_70181_x > 0.0) {
                this.field_70159_w += vector.field_72450_a;
                this.field_70179_y += vector.field_72449_c;
            }
            if (this.field_70181_x < 0.0) {
                this.field_70159_w -= vector.field_72450_a;
                this.field_70179_y -= vector.field_72449_c;
            }
            if (this.velocity < 5.0) {
                this.velocity += 0.01;
            }
        } else {
            this.field_70159_w *= 0.99;
            this.field_70179_y *= 0.99;
            if (this.field_70181_x > -1.5) {
                this.field_70181_x -= 0.05;
            }
        }
        if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150350_a && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150355_j && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150358_i) {
            if (!this.field_70170_p.field_72995_K) {
                this.onImpact();
            }
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            Vec3 v = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
            v = v.func_72432_b();
            String smoke = "";
            ItemMissile part = (ItemMissile)Item.func_150899_d((int)this.field_70180_af.func_75679_c(10));
            ItemMissile.FuelType type = (ItemMissile.FuelType)((Object)part.attributes[0]);
            switch (type) {
                case BALEFIRE: {
                    smoke = "exBalefire";
                    break;
                }
                case HYDROGEN: {
                    smoke = "exHydrogen";
                    break;
                }
                case KEROSENE: {
                    smoke = "exKerosene";
                    break;
                }
                case SOLID: {
                    smoke = "exSolid";
                    break;
                }
            }
            int i = 0;
            while ((double)i < this.velocity) {
                MainRegistry.proxy.spawnParticle(this.field_70165_t - v.field_72450_a * (double)i, this.field_70163_u - v.field_72448_b * (double)i, this.field_70161_v - v.field_72449_c * (double)i, smoke, null);
                ++i;
            }
        }
        this.loadNeighboringChunks((int)(this.field_70165_t / 16.0), (int)(this.field_70161_v / 16.0));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 2500000.0;
    }

    public void onImpact() {
        ItemMissile part = (ItemMissile)Item.func_150899_d((int)this.field_70180_af.func_75679_c(9));
        ItemMissile.WarheadType type = (ItemMissile.WarheadType)((Object)part.attributes[0]);
        float strength = ((Float)part.attributes[1]).floatValue();
        switch (type) {
            case HE: {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, (int)(strength * 50.0f), 0.25);
                break;
            }
            case INC: {
                ExplosionLarge.explodeFire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)strength * 1.5, (int)(strength * 50.0f), 0.25);
                break;
            }
            case CLUSTER: {
                break;
            }
            case BUSTER: {
                ExplosionLarge.buster(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y), strength, strength * 4.0f);
                break;
            }
            case NUCLEAR: 
            case TX: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeCloudSmall nuke = new EntityNukeCloudSmall(this.field_70170_p, 1000, strength * 0.005f);
                nuke.field_70165_t = this.field_70165_t;
                nuke.field_70163_u = this.field_70163_u;
                nuke.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)nuke);
                break;
            }
            case BALEFIRE: {
                EntityBalefire bf = new EntityBalefire(this.field_70170_p);
                bf.field_70165_t = this.field_70165_t;
                bf.field_70163_u = this.field_70163_u;
                bf.field_70161_v = this.field_70161_v;
                bf.destructionRange = (int)strength;
                this.field_70170_p.func_72838_d((Entity)bf);
                this.field_70170_p.func_72838_d((Entity)EntityNukeCloudSmall.statFacBale(this.field_70170_p, this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, strength * 1.5f, 1000));
                break;
            }
            case N2: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK4.statFacNoRad(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeCloudSmall n2 = new EntityNukeCloudSmall(this.field_70170_p, 1000, strength * 0.005f);
                n2.field_70165_t = this.field_70165_t;
                n2.field_70163_u = this.field_70163_u;
                n2.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)n2);
                break;
            }
            case TAINT: {
                int r = (int)strength;
                for (int i = 0; i < r * 10; ++i) {
                    int c;
                    int b;
                    int a = this.field_70146_Z.nextInt(r) + (int)this.field_70165_t - (r / 2 - 1);
                    if (!this.field_70170_p.func_147439_a(a, b = this.field_70146_Z.nextInt(r) + (int)this.field_70163_u - (r / 2 - 1), c = this.field_70146_Z.nextInt(r) + (int)this.field_70161_v - (r / 2 - 1)).isReplaceable((IBlockAccess)this.field_70170_p, a, b, c) || !BlockTaint.hasPosNeightbour(this.field_70170_p, a, b, c)) continue;
                    this.field_70170_p.func_147465_d(a, b, c, ModBlocks.taint, this.field_70146_Z.nextInt(3) + 4, 2);
                }
                break;
            }
            case CLOUD: {
                this.field_70170_p.func_72926_e(2002, (int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v), 0);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y, 750, 2.5, 2);
                break;
            }
            case TURBINE: {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, true, false, true);
                int count = (int)strength;
                Vec3 vec = Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.0);
                for (int i = 0; i < count; ++i) {
                    EntityBulletBase blade = new EntityBulletBase(this.field_70170_p, BulletConfigSyncingUtil.TURBINE);
                    blade.func_70080_a(this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x + this.field_70146_Z.nextGaussian(), this.field_70161_v - this.field_70179_y, 0.0f, 0.0f);
                    blade.field_70159_w = vec.field_72450_a;
                    blade.field_70179_y = vec.field_72449_c;
                    this.field_70170_p.func_72838_d((Entity)blade);
                    vec.func_72442_b((float)(Math.PI * 2 / (double)count));
                }
                break;
            }
        }
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ - 1));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        ItemMissile part = (ItemMissile)Item.func_150899_d((int)this.field_70180_af.func_75679_c(10));
        ItemMissile.PartSize top = part.top;
        ItemMissile.PartSize bottom = part.bottom;
        if (top == ItemMissile.PartSize.SIZE_10 && bottom == ItemMissile.PartSize.SIZE_10) {
            return IRadarDetectable.RadarTargetType.MISSILE_10;
        }
        if (top == ItemMissile.PartSize.SIZE_10 && bottom == ItemMissile.PartSize.SIZE_15) {
            return IRadarDetectable.RadarTargetType.MISSILE_10_15;
        }
        if (top == ItemMissile.PartSize.SIZE_15 && bottom == ItemMissile.PartSize.SIZE_15) {
            return IRadarDetectable.RadarTargetType.MISSILE_15;
        }
        if (top == ItemMissile.PartSize.SIZE_15 && bottom == ItemMissile.PartSize.SIZE_20) {
            return IRadarDetectable.RadarTargetType.MISSILE_15_20;
        }
        if (top == ItemMissile.PartSize.SIZE_20 && bottom == ItemMissile.PartSize.SIZE_20) {
            return IRadarDetectable.RadarTargetType.MISSILE_20;
        }
        return IRadarDetectable.RadarTargetType.PLAYER;
    }
}

