/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class EntityMissileBaseAdvanced
extends Entity
implements IChunkLoader,
IRadarDetectable {
    int startX;
    int startZ;
    int targetX;
    int targetZ;
    public int velocity;
    double decelY;
    double accelXZ;
    boolean isCluster = false;
    private ForgeChunkManager.Ticket loaderTicket;
    public int health = 50;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityMissileBaseAdvanced(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health = (int)((float)this.health - p_70097_2_);
            if (this.health <= 0) {
                this.func_70106_y();
                this.killMissile();
            }
        }
        return true;
    }

    private void killMissile() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
        ExplosionLarge.spawnMissileDebris(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.25, this.getDebris(), this.getDebrisRareDrop());
    }

    public EntityMissileBaseAdvanced(World world, float x, float y, float z, int a, int b) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 1;
        this.func_70105_a(1.5f, 1.5f);
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(8, (Object)this.health);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70159_w = nbt.func_74769_h("moX");
        this.field_70181_x = nbt.func_74769_h("moY");
        this.field_70179_y = nbt.func_74769_h("moZ");
        this.field_70165_t = nbt.func_74769_h("poX");
        this.field_70163_u = nbt.func_74769_h("poY");
        this.field_70161_v = nbt.func_74769_h("poZ");
        this.decelY = nbt.func_74769_h("decel");
        this.accelXZ = nbt.func_74769_h("accel");
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startZ = nbt.func_74762_e("sZ");
        this.velocity = nbt.func_74762_e("veloc");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("moX", this.field_70159_w);
        nbt.func_74780_a("moY", this.field_70181_x);
        nbt.func_74780_a("moZ", this.field_70179_y);
        nbt.func_74780_a("poX", this.field_70165_t);
        nbt.func_74780_a("poY", this.field_70163_u);
        nbt.func_74780_a("poZ", this.field_70161_v);
        nbt.func_74780_a("decel", this.decelY);
        nbt.func_74780_a("accel", this.accelXZ);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74768_a("veloc", this.velocity);
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void func_70071_h_() {
        if (this.velocity < 1) {
            this.velocity = 1;
        }
        if (this.field_70173_aa > 40) {
            this.velocity = 3;
        } else if (this.field_70173_aa > 20) {
            this.velocity = 2;
        }
        this.field_70180_af.func_75692_b(8, (Object)this.health);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        for (int i = 0; i < this.velocity; ++i) {
            this.func_70012_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y, 0.0f, 0.0f);
            this.rotation();
            this.field_70181_x -= this.decelY;
            Vec3 vector = Vec3.func_72443_a((double)(this.targetX - this.startX), (double)0.0, (double)(this.targetZ - this.startZ));
            vector = vector.func_72432_b();
            vector.field_72450_a *= this.accelXZ;
            vector.field_72449_c *= this.accelXZ;
            if (this.field_70181_x > 0.0) {
                this.field_70159_w += vector.field_72450_a;
                this.field_70179_y += vector.field_72449_c;
            }
            if (this.field_70181_x < 0.0) {
                this.field_70159_w -= vector.field_72450_a;
                this.field_70179_y -= vector.field_72449_c;
            }
            if (!this.field_70170_p.field_72995_K) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 300.0));
            }
            if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150350_a && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150355_j && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) != Blocks.field_150358_i) {
                if (!this.field_70170_p.field_72995_K) {
                    this.onImpact();
                }
                this.func_70106_y();
                return;
            }
            this.loadNeighboringChunks((int)(this.field_70165_t / 16.0), (int)(this.field_70161_v / 16.0));
            if (!(this.field_70181_x < -1.0) || !this.isCluster || this.field_70170_p.field_72995_K) continue;
            this.cluster();
            this.func_70106_y();
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 500000.0;
    }

    public abstract void onImpact();

    public abstract List<ItemStack> getDebris();

    public abstract ItemStack getDebrisRareDrop();

    public void cluster() {
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ - 1));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }
}

