/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.particle.EntityGasFlameFX;
import com.hbm.entity.projectile.EntityBombletZeta;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.entity.projectile.EntityRocketHoming;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedEntitySoundPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityBomber
extends Entity
implements IChunkLoader {
    int timer = 200;
    int bombStart = 75;
    int bombStop = 125;
    int bombRate = 3;
    int type = 0;
    public int health = 50;
    private ForgeChunkManager.Ticket loaderTicket;
    List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();

    public EntityBomber(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70158_ak = true;
        this.func_70105_a(8.0f, 4.0f);
    }

    public boolean func_70067_L() {
        return this.health > 0;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_ == ModDamageSource.nuclearBlast) {
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K && this.health > 0) {
            this.health = (int)((float)this.health - p_70097_2_);
            if (this.health <= 0) {
                this.killBomber();
            }
        }
        return true;
    }

    private void killBomber() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:entity.planeShotDown", 25.0f, 1.0f);
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70166_s = this.field_70161_v;
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)this.health);
            if (this.health > 0) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new LoopedEntitySoundPacket(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 250.0));
            }
        } else {
            this.health = this.field_70180_af.func_75679_c(17);
        }
        this.rotation();
        if (this.health <= 0) {
            this.field_70181_x -= 0.025;
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_72838_d((Entity)new EntityGasFlameFX(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70159_w * 2.0, this.field_70163_u + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70181_x * 2.0, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70179_y * 2.0, 0.0, 0.1, 0.0));
            }
            if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).func_149721_r() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                ExplosionLarge.explodeFire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0f, true, false, true);
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:entity.planeCrash", 10.0f, 1.0f);
                return;
            }
        }
        if (this.field_70173_aa > this.timer) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.health > 0 && this.field_70173_aa > this.bombStart && this.field_70173_aa < this.bombStop && this.field_70173_aa % this.bombRate == 0) {
            if (this.type == 3) {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "random.fizz", 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, 10, 0.5, 3);
            } else if (this.type == 5) {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:weapon.missileTakeOff", 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                EntityRocketHoming rocket = new EntityRocketHoming(this.field_70170_p);
                rocket.setIsCritical(true);
                rocket.field_70181_x = -1.0;
                rocket.shootingEntity = this;
                rocket.homingRadius = 50;
                rocket.homingMod = 5;
                rocket.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                rocket.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                rocket.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                this.field_70170_p.func_72838_d((Entity)rocket);
            } else if (this.type == 6) {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:weapon.missileTakeOff", 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                EntityBoxcar rocket = new EntityBoxcar(this.field_70170_p);
                rocket.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                rocket.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                rocket.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                this.field_70170_p.func_72838_d((Entity)rocket);
            } else if (this.type == 7) {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "random.fizz", 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t, this.field_70170_p.func_72976_f((int)this.field_70165_t, (int)this.field_70161_v) + 2, this.field_70161_v, 10, 1.0, 2);
            } else {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "hbm:entity.bombWhistle", 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                EntityBombletZeta zeta = new EntityBombletZeta(this.field_70170_p);
                zeta.rotation();
                zeta.type = this.type;
                zeta.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                zeta.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                zeta.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                if (this.type == 0) {
                    zeta.field_70159_w = this.field_70159_w + this.field_70146_Z.nextGaussian() * 0.15;
                    zeta.field_70179_y = this.field_70179_y + this.field_70146_Z.nextGaussian() * 0.15;
                } else {
                    zeta.field_70159_w = this.field_70159_w;
                    zeta.field_70179_y = this.field_70179_y;
                }
                this.field_70170_p.func_72838_d((Entity)zeta);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.loadNeighboringChunks((int)(this.field_70165_t / 16.0), (int)(this.field_70161_v / 16.0));
        }
    }

    public void fac(World world, double x, double y, double z) {
        Vec3 vector = Vec3.func_72443_a((double)(world.field_73012_v.nextDouble() - 0.5), (double)0.0, (double)(world.field_73012_v.nextDouble() - 0.5));
        vector = vector.func_72432_b();
        vector.field_72450_a = vector.field_72450_a * (GeneralConfig.enableBomberShortMode ? 1.0 : 2.0);
        vector.field_72449_c = vector.field_72449_c * (GeneralConfig.enableBomberShortMode ? 1.0 : 2.0);
        this.func_70012_b(x - vector.field_72450_a * 100.0, y + 50.0, z - vector.field_72449_c * 100.0, 0.0f, 0.0f);
        this.loadNeighboringChunks((int)(x / 16.0), (int)(z / 16.0));
        this.field_70159_w = vector.field_72450_a;
        this.field_70179_y = vector.field_72449_c;
        this.field_70181_x = 0.0;
        this.rotation();
        int i = 1;
        int rand = world.field_73012_v.nextInt(7);
        switch (rand) {
            case 0: 
            case 1: {
                i = 1;
                break;
            }
            case 2: 
            case 3: {
                i = 2;
                break;
            }
            case 4: {
                i = 5;
                break;
            }
            case 5: {
                i = 6;
                break;
            }
            case 6: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            rand = world.field_73012_v.nextInt(4);
            switch (rand) {
                case 0: {
                    i = 0;
                    break;
                }
                case 1: {
                    i = 3;
                    break;
                }
                case 2: {
                    i = 4;
                    break;
                }
                case 3: {
                    i = 8;
                }
            }
        }
        this.func_70096_w().func_75692_b(16, (Object)((byte)i));
        this.func_70105_a(8.0f, 4.0f);
    }

    public static EntityBomber statFacCarpet(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 2;
        bomber.fac(world, x, y, z);
        bomber.type = 0;
        return bomber;
    }

    public static EntityBomber statFacNapalm(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 5;
        bomber.fac(world, x, y, z);
        bomber.type = 1;
        return bomber;
    }

    public static EntityBomber statFacChlorine(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 4;
        bomber.fac(world, x, y, z);
        bomber.type = 2;
        return bomber;
    }

    public static EntityBomber statFacOrange(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.type = 3;
        return bomber;
    }

    public static EntityBomber statFacABomb(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 60;
        bomber.bombStop = 70;
        bomber.bombRate = 65;
        bomber.fac(world, x, y, z);
        int i = 1;
        int rand = world.field_73012_v.nextInt(3);
        switch (rand) {
            case 0: {
                i = 5;
                break;
            }
            case 1: {
                i = 6;
                break;
            }
            case 2: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            i = 8;
        }
        bomber.func_70096_w().func_75692_b(16, (Object)((byte)i));
        bomber.type = 4;
        return bomber;
    }

    public static EntityBomber statFacStinger(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)4);
        bomber.type = 5;
        return bomber;
    }

    public static EntityBomber statFacBoxcar(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)6);
        bomber.type = 6;
        return bomber;
    }

    public static EntityBomber statFacPC(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.func_70096_w().func_75692_b(16, (Object)6);
        bomber.type = 7;
        return bomber;
    }

    public void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)50);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70173_aa = nbt.func_74762_e("ticksExisted");
        this.bombStart = nbt.func_74762_e("bombStart");
        this.bombStop = nbt.func_74762_e("bombStop");
        this.bombRate = nbt.func_74762_e("bombRate");
        this.type = nbt.func_74762_e("type");
        this.func_70096_w().func_75692_b(16, (Object)nbt.func_74771_c("style"));
        this.func_70096_w().func_75692_b(17, (Object)nbt.func_74762_e("health"));
        this.func_70105_a(8.0f, 4.0f);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksExisted", this.field_70173_aa);
        nbt.func_74768_a("bombStart", this.bombStart);
        nbt.func_74768_a("bombStop", this.bombStop);
        nbt.func_74768_a("bombRate", this.bombRate);
        nbt.func_74768_a("type", this.type);
        nbt.func_74774_a("style", this.func_70096_w().func_75683_a(16));
        nbt.func_74768_a("health", this.func_70096_w().func_75679_c(17));
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 500000.0;
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ - 1));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }
}

