/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityMinecartCommandBlock;
import net.minecraft.entity.ai.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;

public abstract class EntityMinecartModBase
extends EntityMinecart {
    private boolean isInReverse;
    private String entityName;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private static final String __OBFID = "CL_00001670";
    public static float defaultMaxSpeedAirLateral = 0.4f;
    public static float defaultMaxSpeedAirVertical = -1.0f;
    public static double defaultDragAir = 0.95f;
    protected boolean canUseRail = true;
    protected boolean canBePushed = true;
    private static IMinecartCollisionHandler collisionHandler = null;
    private float currentSpeedRail = this.getMaxCartSpeedOnRail();
    protected float maxSpeedAirLateral = defaultMaxSpeedAirLateral;
    protected float maxSpeedAirVertical = defaultMaxSpeedAirVertical;
    protected double dragAir = defaultDragAir;

    public EntityMinecartModBase(World p_i1712_1_) {
        super(p_i1712_1_);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.7f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public static EntityMinecart createMinecart(World p_94090_0_, double p_94090_1_, double p_94090_3_, double p_94090_5_, int p_94090_7_) {
        switch (p_94090_7_) {
            case 1: {
                return new EntityMinecartChest(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 2: {
                return new EntityMinecartFurnace(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 3: {
                return new EntityMinecartTNT(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 4: {
                return new EntityMinecartMobSpawner(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 5: {
                return new EntityMinecartHopper(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 6: {
                return new EntityMinecartCommandBlock(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
        }
        return new EntityMinecartEmpty(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(21, (Object)new Integer(6));
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(24, (Object)new Integer(0));
    }

    public AxisAlignedBB func_70114_g(Entity p_70114_1_) {
        if (EntityMinecartModBase.getCollisionHandler() != null) {
            return EntityMinecartModBase.getCollisionHandler().getCollisionBox((EntityMinecart)this, p_70114_1_);
        }
        return p_70114_1_.func_70104_M() ? p_70114_1_.field_70121_D : null;
    }

    public AxisAlignedBB func_70046_E() {
        if (EntityMinecartModBase.getCollisionHandler() != null) {
            return EntityMinecartModBase.getCollisionHandler().getBoundingBox((EntityMinecart)this);
        }
        return null;
    }

    public boolean func_70104_M() {
        return this.canBePushed;
    }

    public EntityMinecartModBase(World p_i1713_1_, double p_i1713_2_, double p_i1713_4_, double p_i1713_6_) {
        this(p_i1713_1_);
        this.func_70107_b(p_i1713_2_, p_i1713_4_, p_i1713_6_);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = p_i1713_2_;
        this.field_70167_r = p_i1713_4_;
        this.field_70166_s = p_i1713_6_;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (this.func_85032_ar()) {
                return false;
            }
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            this.func_70492_c(this.func_70491_i() + p_70097_2_ * 10.0f);
            boolean bl = flag = p_70097_1_.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)p_70097_1_.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70491_i() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (flag && !this.func_145818_k_()) {
                    this.func_70106_y();
                } else {
                    this.func_94095_a(p_70097_1_);
                }
            }
            return true;
        }
        return true;
    }

    public void func_94095_a(DamageSource p_94095_1_) {
        this.func_70106_y();
        ItemStack itemstack = new ItemStack(Items.field_151143_au, 1);
        if (this.entityName != null) {
            itemstack.func_151001_c(this.entityName);
        }
        this.func_70099_a(itemstack, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70492_c(this.func_70491_i() + this.func_70491_i() * 10.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_70071_h_() {
        int i;
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (this.field_70159_w < 0.0) {
            this.field_70180_af.func_75692_b(23, (Object)-1);
        }
        if (this.field_70159_w > 0.0) {
            this.field_70180_af.func_75692_b(23, (Object)1);
        }
        if (this.field_70159_w == 0.0 && this.field_70179_y != 0.0) {
            this.field_70180_af.func_75692_b(23, (Object)0);
        }
        if (this.field_70179_y < 0.0) {
            this.field_70180_af.func_75692_b(24, (Object)-1);
        }
        if (this.field_70179_y > 0.0) {
            this.field_70180_af.func_75692_b(24, (Object)1);
        }
        if (this.field_70179_y == 0.0 && this.field_70159_w != 0.0) {
            this.field_70180_af.func_75692_b(24, (Object)0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer minecraftserver = ((WorldServer)this.field_70170_p).func_73046_m();
            i = this.func_82145_z();
            if (this.field_71087_bX) {
                if (minecraftserver.func_71255_r()) {
                    if (this.field_70154_o == null && this.field_82153_h++ >= i) {
                        this.field_82153_h = i;
                        this.field_71088_bW = this.func_82147_ab();
                        int b0 = this.field_70170_p.field_73011_w.field_76574_g == -1 ? 0 : -1;
                        this.func_71027_c(b0);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.turnProgress > 0) {
                double d6 = this.field_70165_t + (this.minecartX - this.field_70165_t) / (double)this.turnProgress;
                double d7 = this.field_70163_u + (this.minecartY - this.field_70163_u) / (double)this.turnProgress;
                double d1 = this.field_70161_v + (this.minecartZ - this.field_70161_v) / (double)this.turnProgress;
                double d3 = MathHelper.func_76138_g((double)(this.minecartYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.minecartPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(d6, d7, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            double d5;
            int i1;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70181_x -= (double)0.04f;
            int l = MathHelper.func_76128_c((double)this.field_70165_t);
            if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)l, (int)((i = MathHelper.func_76128_c((double)this.field_70163_u)) - 1), (int)(i1 = MathHelper.func_76128_c((double)this.field_70161_v)))) {
                --i;
            }
            double d0 = 0.4;
            Block block = this.field_70170_p.func_147439_a(l, i, i1);
            if (this.canUseRail() && BlockRailBase.func_150051_a((Block)block)) {
                float railMaxSpeed = ((BlockRailBase)block).getRailMaxSpeed(this.field_70170_p, (EntityMinecart)this, l, i, i1);
                double maxSpeed = Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
                this.func_145821_a(l, i, i1, maxSpeed, this.getSlopeAdjustment(), block, ((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, l, i, i1));
                if (block == Blocks.field_150408_cc) {
                    this.func_96095_a(l, i, i1, (this.field_70170_p.func_72805_g(l, i, i1) & 8) != 0);
                }
            } else {
                this.func_94088_b(this.field_70122_E ? d0 : (double)this.getMaxSpeedAirLateral());
            }
            this.func_145775_I();
            this.field_70125_A = 0.0f;
            double d8 = this.field_70169_q - this.field_70165_t;
            double d4 = this.field_70166_s - this.field_70161_v;
            if (d8 * d8 + d4 * d4 > 0.001) {
                this.field_70177_z = (float)(Math.atan2(d4, d8) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.field_70177_z += 180.0f;
                }
            }
            if ((d5 = (double)MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B))) < -170.0 || d5 >= 170.0) {
                this.field_70177_z += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            AxisAlignedBB box = EntityMinecartModBase.getCollisionHandler() != null ? EntityMinecartModBase.getCollisionHandler().getMinecartCollisionBox((EntityMinecart)this) : this.field_70121_D.func_72314_b(0.2, 0.0, 0.2);
            List list = this.field_70170_p.func_72839_b((Entity)this, box);
            if (list != null && !list.isEmpty()) {
                for (int k = 0; k < list.size(); ++k) {
                    Entity entity = (Entity)list.get(k);
                    if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityMinecart)) continue;
                    entity.func_70108_f((Entity)this);
                }
            }
            if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                if (this.field_70153_n.field_70154_o == this) {
                    this.field_70153_n.field_70154_o = null;
                }
                this.field_70153_n = null;
            }
            MinecraftForge.EVENT_BUS.post((Event)new MinecartUpdateEvent((EntityMinecart)this, (float)l, (float)i, (float)i1));
        }
    }

    public void func_96095_a(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
    }

    protected void func_94088_b(double p_94088_1_) {
        if (this.field_70159_w < -p_94088_1_) {
            this.field_70159_w = -p_94088_1_;
        }
        if (this.field_70159_w > p_94088_1_) {
            this.field_70159_w = p_94088_1_;
        }
        if (this.field_70179_y < -p_94088_1_) {
            this.field_70179_y = -p_94088_1_;
        }
        if (this.field_70179_y > p_94088_1_) {
            this.field_70179_y = p_94088_1_;
        }
        double moveY = this.field_70181_x;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.field_70181_x > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.field_70159_w) < (double)0.3f && Math.abs(this.field_70179_y) < (double)0.3f) {
                this.field_70181_x = moveY = (double)0.15f;
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, moveY, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= this.getDragAir();
            this.field_70181_x *= this.getDragAir();
            this.field_70179_y *= this.getDragAir();
        }
    }

    protected void func_145821_a(int p_145821_1_, int p_145821_2_, int p_145821_3_, double p_145821_4_, double p_145821_6_, Block p_145821_8_, int p_145821_9_) {
        double d10;
        double d9;
        double d8;
        double d7;
        double d6;
        this.field_70143_R = 0.0f;
        Vec3 vec3 = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70163_u = p_145821_2_;
        boolean flag = false;
        boolean flag1 = false;
        if (p_145821_8_ == Blocks.field_150318_D) {
            flag = (this.field_70170_p.func_72805_g(p_145821_1_, p_145821_2_, p_145821_3_) & 8) != 0;
            boolean bl = flag1 = !flag;
        }
        if (((BlockRailBase)p_145821_8_).func_150050_e()) {
            p_145821_9_ &= 7;
        }
        if (p_145821_9_ >= 2 && p_145821_9_ <= 5) {
            this.field_70163_u = p_145821_2_ + 1;
        }
        if (p_145821_9_ == 2) {
            this.field_70159_w -= p_145821_6_;
        }
        if (p_145821_9_ == 3) {
            this.field_70159_w += p_145821_6_;
        }
        if (p_145821_9_ == 4) {
            this.field_70179_y += p_145821_6_;
        }
        if (p_145821_9_ == 5) {
            this.field_70179_y -= p_145821_6_;
        }
        int[][] aint = matrix[p_145821_9_];
        double d2 = aint[1][0] - aint[0][0];
        double d3 = aint[1][2] - aint[0][2];
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = this.field_70159_w * d2 + this.field_70179_y * d3;
        if (d5 < 0.0) {
            d2 = -d2;
            d3 = -d3;
        }
        if ((d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 2.0) {
            d6 = 2.0;
        }
        this.field_70159_w = d6 * d2 / d4;
        this.field_70179_y = d6 * d3 / d4;
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && (d7 = (double)((EntityLivingBase)this.field_70153_n).field_70701_bs) > 0.0) {
            d8 = -Math.sin(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
            d9 = Math.cos(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
            d10 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
            if (d10 < 0.01) {
                this.field_70159_w += d8 * 0.1;
                this.field_70179_y += d9 * 0.1;
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            d7 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d7 < 0.03) {
                this.field_70159_w *= 0.0;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.0;
            } else {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.5;
            }
        }
        d7 = 0.0;
        d8 = (double)p_145821_1_ + 0.5 + (double)aint[0][0] * 0.5;
        d9 = (double)p_145821_3_ + 0.5 + (double)aint[0][2] * 0.5;
        d10 = (double)p_145821_1_ + 0.5 + (double)aint[1][0] * 0.5;
        double d11 = (double)p_145821_3_ + 0.5 + (double)aint[1][2] * 0.5;
        d2 = d10 - d8;
        d3 = d11 - d9;
        if (d2 == 0.0) {
            this.field_70165_t = (double)p_145821_1_ + 0.5;
            d7 = this.field_70161_v - (double)p_145821_3_;
        } else if (d3 == 0.0) {
            this.field_70161_v = (double)p_145821_3_ + 0.5;
            d7 = this.field_70165_t - (double)p_145821_1_;
        } else {
            double d12 = this.field_70165_t - d8;
            double d13 = this.field_70161_v - d9;
            d7 = (d12 * d2 + d13 * d3) * 2.0;
        }
        this.field_70165_t = d8 + d2 * d7;
        this.field_70161_v = d9 + d3 * d7;
        this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M, this.field_70161_v);
        this.moveMinecartOnRail(p_145821_1_, p_145821_2_, p_145821_3_, p_145821_4_);
        if (aint[0][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - p_145821_1_ == aint[0][0] && MathHelper.func_76128_c((double)this.field_70161_v) - p_145821_3_ == aint[0][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)aint[0][1], this.field_70161_v);
        } else if (aint[1][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - p_145821_1_ == aint[1][0] && MathHelper.func_76128_c((double)this.field_70161_v) - p_145821_3_ == aint[1][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)aint[1][1], this.field_70161_v);
        }
        this.func_94101_h();
        Vec3 vec31 = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (vec31 != null && vec3 != null) {
            double d14 = (vec3.field_72448_b - vec31.field_72448_b) * 0.05;
            d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d6 > 0.0) {
                this.field_70159_w = this.field_70159_w / d6 * (d6 + d14);
                this.field_70179_y = this.field_70179_y / d6 * (d6 + d14);
            }
            this.func_70107_b(this.field_70165_t, vec31.field_72448_b, this.field_70161_v);
        }
        int j1 = MathHelper.func_76128_c((double)this.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)this.field_70161_v);
        if (j1 != p_145821_1_ || i1 != p_145821_3_) {
            d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70159_w = d6 * (double)(j1 - p_145821_1_);
            this.field_70179_y = d6 * (double)(i1 - p_145821_3_);
        }
        if (this.shouldDoRailFunctions()) {
            ((BlockRailBase)p_145821_8_).onMinecartPass(this.field_70170_p, (EntityMinecart)this, p_145821_1_, p_145821_2_, p_145821_3_);
        }
        if (flag && this.shouldDoRailFunctions()) {
            double d15 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d15 > 0.01) {
                double d16 = 0.06;
                this.field_70159_w += this.field_70159_w / d15 * d16;
                this.field_70179_y += this.field_70179_y / d15 * d16;
            } else if (p_145821_9_ == 1) {
                if (this.field_70170_p.func_147439_a(p_145821_1_ - 1, p_145821_2_, p_145821_3_).func_149721_r()) {
                    this.field_70159_w = 0.02;
                } else if (this.field_70170_p.func_147439_a(p_145821_1_ + 1, p_145821_2_, p_145821_3_).func_149721_r()) {
                    this.field_70159_w = -0.02;
                }
            } else if (p_145821_9_ == 0) {
                if (this.field_70170_p.func_147439_a(p_145821_1_, p_145821_2_, p_145821_3_ - 1).func_149721_r()) {
                    this.field_70179_y = 0.02;
                } else if (this.field_70170_p.func_147439_a(p_145821_1_, p_145821_2_, p_145821_3_ + 1).func_149721_r()) {
                    this.field_70179_y = -0.02;
                }
            }
        }
    }

    protected void func_94101_h() {
        if (this.field_70153_n != null) {
            this.field_70159_w *= (double)0.997f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.997f;
        } else {
            this.field_70159_w *= (double)0.96f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.96f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_70495_a(double p_70495_1_, double p_70495_3_, double p_70495_5_, double p_70495_7_) {
        Block block;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)p_70495_1_);
        if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)i, (int)((j = MathHelper.func_76128_c((double)p_70495_3_)) - 1), (int)(k = MathHelper.func_76128_c((double)p_70495_5_)))) {
            --j;
        }
        if (!BlockRailBase.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(i, j, k)))) {
            return null;
        }
        int l = ((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
        p_70495_3_ = j;
        if (l >= 2 && l <= 5) {
            p_70495_3_ = j + 1;
        }
        int[][] aint = matrix[l];
        double d4 = aint[1][0] - aint[0][0];
        double d5 = aint[1][2] - aint[0][2];
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        if (aint[0][1] != 0 && MathHelper.func_76128_c((double)(p_70495_1_ += (d4 /= d6) * p_70495_7_)) - i == aint[0][0] && MathHelper.func_76128_c((double)(p_70495_5_ += (d5 /= d6) * p_70495_7_)) - k == aint[0][2]) {
            p_70495_3_ += (double)aint[0][1];
        } else if (aint[1][1] != 0 && MathHelper.func_76128_c((double)p_70495_1_) - i == aint[1][0] && MathHelper.func_76128_c((double)p_70495_5_) - k == aint[1][2]) {
            p_70495_3_ += (double)aint[1][1];
        }
        return this.func_70489_a(p_70495_1_, p_70495_3_, p_70495_5_);
    }

    public Vec3 func_70489_a(double p_70489_1_, double p_70489_3_, double p_70489_5_) {
        Block block;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)p_70489_1_);
        if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)i, (int)((j = MathHelper.func_76128_c((double)p_70489_3_)) - 1), (int)(k = MathHelper.func_76128_c((double)p_70489_5_)))) {
            --j;
        }
        if (BlockRailBase.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(i, j, k)))) {
            int l = ((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, i, j, k);
            p_70489_3_ = j;
            if (l >= 2 && l <= 5) {
                p_70489_3_ = j + 1;
            }
            int[][] aint = matrix[l];
            double d3 = 0.0;
            double d4 = (double)i + 0.5 + (double)aint[0][0] * 0.5;
            double d5 = (double)j + 0.5 + (double)aint[0][1] * 0.5;
            double d6 = (double)k + 0.5 + (double)aint[0][2] * 0.5;
            double d7 = (double)i + 0.5 + (double)aint[1][0] * 0.5;
            double d8 = (double)j + 0.5 + (double)aint[1][1] * 0.5;
            double d9 = (double)k + 0.5 + (double)aint[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                p_70489_1_ = (double)i + 0.5;
                d3 = p_70489_5_ - (double)k;
            } else if (d12 == 0.0) {
                p_70489_5_ = (double)k + 0.5;
                d3 = p_70489_1_ - (double)i;
            } else {
                double d13 = p_70489_1_ - d4;
                double d14 = p_70489_5_ - d6;
                d3 = (d13 * d10 + d14 * d12) * 2.0;
            }
            p_70489_1_ = d4 + d10 * d3;
            p_70489_3_ = d5 + d11 * d3;
            p_70489_5_ = d6 + d12 * d3;
            if (d11 < 0.0) {
                p_70489_3_ += 1.0;
            }
            if (d11 > 0.0) {
                p_70489_3_ += 0.5;
            }
            return Vec3.func_72443_a((double)p_70489_1_, (double)p_70489_3_, (double)p_70489_5_);
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        if (p_70037_1_.func_74767_n("CustomDisplayTile")) {
            this.func_145819_k(p_70037_1_.func_74762_e("DisplayTile"));
            this.func_94092_k(p_70037_1_.func_74762_e("DisplayData"));
            this.func_94086_l(p_70037_1_.func_74762_e("DisplayOffset"));
        }
        if (p_70037_1_.func_150297_b("CustomName", 8) && p_70037_1_.func_74779_i("CustomName").length() > 0) {
            this.entityName = p_70037_1_.func_74779_i("CustomName");
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        if (this.func_94100_s()) {
            p_70014_1_.func_74757_a("CustomDisplayTile", true);
            p_70014_1_.func_74768_a("DisplayTile", this.func_145820_n().func_149688_o() == Material.field_151579_a ? 0 : Block.func_149682_b((Block)this.func_145820_n()));
            p_70014_1_.func_74768_a("DisplayData", this.func_94098_o());
            p_70014_1_.func_74768_a("DisplayOffset", this.func_94099_q());
        }
        if (this.entityName != null && this.entityName.length() > 0) {
            p_70014_1_.func_74778_a("CustomName", this.entityName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70108_f(Entity p_70108_1_) {
        MinecraftForge.EVENT_BUS.post((Event)new MinecartCollisionEvent((EntityMinecart)this, p_70108_1_));
        if (EntityMinecartModBase.getCollisionHandler() != null) {
            EntityMinecartModBase.getCollisionHandler().onEntityCollision((EntityMinecart)this, p_70108_1_);
            return;
        }
        if (!this.field_70170_p.field_72995_K && p_70108_1_ != this.field_70153_n) {
            double d1;
            double d0;
            double d2;
            if (p_70108_1_ instanceof EntityLivingBase && !(p_70108_1_ instanceof EntityPlayer) && !(p_70108_1_ instanceof EntityIronGolem) && this.canBeRidden() && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.01 && this.field_70153_n == null && p_70108_1_.field_70154_o == null) {
                p_70108_1_.func_70078_a((Entity)this);
            }
            if ((d2 = (d0 = p_70108_1_.field_70165_t - this.field_70165_t) * d0 + (d1 = p_70108_1_.field_70161_v - this.field_70161_v) * d1) >= (double)1.0E-4f) {
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                d0 *= 0.5;
                d1 *= 0.5;
                if (p_70108_1_ instanceof EntityMinecart) {
                    Vec3 vec31;
                    double d4 = p_70108_1_.field_70165_t - this.field_70165_t;
                    double d5 = p_70108_1_.field_70161_v - this.field_70161_v;
                    Vec3 vec3 = Vec3.func_72443_a((double)d4, (double)0.0, (double)d5).func_72432_b();
                    double d6 = Math.abs(vec3.func_72430_b(vec31 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b()));
                    if (d6 < (double)0.8f) {
                        return;
                    }
                    double d7 = p_70108_1_.field_70159_w + this.field_70159_w;
                    double d8 = p_70108_1_.field_70179_y + this.field_70179_y;
                    if (((EntityMinecart)p_70108_1_).isPoweredCart() && !this.isPoweredCart()) {
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g(p_70108_1_.field_70159_w - d0, 0.0, p_70108_1_.field_70179_y - d1);
                        p_70108_1_.field_70159_w *= (double)0.95f;
                        p_70108_1_.field_70179_y *= (double)0.95f;
                    } else if (((EntityMinecart)p_70108_1_).isPoweredCart() && !this.isPoweredCart()) {
                        p_70108_1_.field_70159_w *= (double)0.2f;
                        p_70108_1_.field_70179_y *= (double)0.2f;
                        p_70108_1_.func_70024_g(this.field_70159_w + d0, 0.0, this.field_70179_y + d1);
                        this.field_70159_w *= (double)0.95f;
                        this.field_70179_y *= (double)0.95f;
                    } else {
                        this.field_70159_w *= (double)0.2f;
                        this.field_70179_y *= (double)0.2f;
                        this.func_70024_g((d7 /= 2.0) - d0, 0.0, (d8 /= 2.0) - d1);
                        p_70108_1_.field_70159_w *= (double)0.2f;
                        p_70108_1_.field_70179_y *= (double)0.2f;
                        p_70108_1_.func_70024_g(d7 + d0, 0.0, d8 + d1);
                    }
                } else {
                    this.func_70024_g(-d0, 0.0, -d1);
                    p_70108_1_.func_70024_g(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double p_70056_1_, double p_70056_3_, double p_70056_5_, float p_70056_7_, float p_70056_8_, int p_70056_9_) {
        this.minecartX = p_70056_1_;
        this.minecartY = p_70056_3_;
        this.minecartZ = p_70056_5_;
        this.minecartYaw = p_70056_7_;
        this.minecartPitch = p_70056_8_;
        this.turnProgress = p_70056_9_ + 2;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70492_c(float p_70492_1_) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(p_70492_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.velocityX = this.field_70159_w = p_70016_1_;
        this.velocityY = this.field_70181_x = p_70016_3_;
        this.velocityZ = this.field_70179_y = p_70016_5_;
    }

    public float func_70491_i() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void func_70497_h(int p_70497_1_) {
        this.field_70180_af.func_75692_b(17, (Object)p_70497_1_);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void func_70494_i(int p_70494_1_) {
        this.field_70180_af.func_75692_b(18, (Object)p_70494_1_);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_75679_c(18);
    }

    public abstract int func_94087_l();

    public Block func_145820_n() {
        if (!this.func_94100_s()) {
            return this.func_145817_o();
        }
        int i = this.func_70096_w().func_75679_c(20) & 0xFFFF;
        return Block.func_149729_e((int)i);
    }

    public Block func_145817_o() {
        return Blocks.field_150350_a;
    }

    public int func_94098_o() {
        return !this.func_94100_s() ? this.func_94097_p() : this.func_70096_w().func_75679_c(20) >> 16;
    }

    public int func_94097_p() {
        return 0;
    }

    public int func_94099_q() {
        return !this.func_94100_s() ? this.func_94085_r() : this.func_70096_w().func_75679_c(21);
    }

    public int func_94085_r() {
        return 6;
    }

    public void func_145819_k(int p_145819_1_) {
        this.func_70096_w().func_75692_b(20, (Object)(p_145819_1_ & 0xFFFF | this.func_94098_o() << 16));
        this.func_94096_e(true);
    }

    public void func_94092_k(int p_94092_1_) {
        this.func_70096_w().func_75692_b(20, (Object)(Block.func_149682_b((Block)this.func_145820_n()) & 0xFFFF | p_94092_1_ << 16));
        this.func_94096_e(true);
    }

    public void func_94086_l(int p_94086_1_) {
        this.func_70096_w().func_75692_b(21, (Object)p_94086_1_);
        this.func_94096_e(true);
    }

    public boolean func_94100_s() {
        return this.func_70096_w().func_75683_a(22) == 1;
    }

    public void func_94096_e(boolean p_94096_1_) {
        this.func_70096_w().func_75692_b(22, (Object)((byte)(p_94096_1_ ? 1 : 0)));
    }

    public void func_96094_a(String p_96094_1_) {
        this.entityName = p_96094_1_;
    }

    public String func_70005_c_() {
        return this.entityName != null ? this.entityName : super.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.entityName != null;
    }

    public String func_95999_t() {
        return this.entityName;
    }

    public void moveMinecartOnRail(int x, int y, int z, double par4) {
        double d12 = this.field_70159_w;
        double d13 = this.field_70179_y;
        if (this.field_70153_n != null) {
            d12 *= 0.75;
            d13 *= 0.75;
        }
        if (d12 < -par4) {
            d12 = -par4;
        }
        if (d12 > par4) {
            d12 = par4;
        }
        if (d13 < -par4) {
            d13 = -par4;
        }
        if (d13 > par4) {
            d13 = par4;
        }
        this.func_70091_d(d12, 0.0, d13);
    }

    public static IMinecartCollisionHandler getCollisionHandler() {
        return collisionHandler;
    }

    public static void setCollisionHandler(IMinecartCollisionHandler handler) {
        collisionHandler = handler;
    }

    public ItemStack getCartItem() {
        return new ItemStack(Items.field_151143_au);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    public boolean isPoweredCart() {
        return this.func_94087_l() == 2;
    }

    public boolean canBeRidden() {
        return false;
    }

    public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public double getSlopeAdjustment() {
        return 0.0078125;
    }
}

